//////////////////////////////////////
// Xuice Embeded Media Player 1.0	//
// 꽺 Ӻ ̵÷̾ 1.0	//
//////////////////////////////////////

//////////////////////////////////////
// Variables 
var bPlaying = true; //   (autoStart ó true)

///////////////////////////////////////
// Functions Լ


// It checks and returns current track number, bit rate, title and current status.
//    : Ʈ, ƮƮ,   üũϿ  ¸ ȯ
function getStatus()
{	
	var artist;
	var title;
	var status;

	switch ( player.playState )
	{
		case 0: status = "˼»"; break;
		case 1: status = ""; break;
		case 2: status = "Ͻ";break;
		case 3: status = ""; break;
		case 4: status = ""; break;
		case 5: status = "ǰ"; break;
		case 6: status = "۸.."; break;
		case 7:	status = ".."; break;
		case 8: status = ""; break;
		case 9: status = "غ.."; break;
		case 10: status = "غ"; break;
	}
	
	artist = player.currentMedia.getItemInfo('Artist') + " - ";
	title = player.currentMedia.getItemInfo('Title') + " / ";
	
	if ( artist == " - " && title == " / " )
	{
		return player.currentMedia.getItemInfo('SourceURL')+" / "+status;
	}
	else
	{
		if ( artist == " - " )
			artist = "   ƼƮ - ";

		if ( title == " / " )
			title = " / ";

		return artist+title+status;
	}
}


//previous track : Move to previous track
//Ʈ : Ʈ   Ʈ ùƮϰ Ʈ ٽ Ѵ
function previous()
{
	player.controls.previous();

	Music_Title.value = getStatus();

	if ( bPlaying )
		player.controls.play();
	else
		player.controls.stop();	
}

//next track : Move to next track
//Ʈ : Ʈ   Ʈΰ  Ѵ
function next()
{
	player.controls.next();

	Music_Title.value = getStatus();

	if ( bPlaying )
		player.controls.play();
	else
		player.controls.stop();	
}


//play : play the track
// : Ѵ.
function play()
{
	player.controls.play();
	bPlaying = true;

	Music_Title.value = getStatus();
}

//stop : stop the track
// : Ѵ.
function stop()
{
	player.controls.stop();
	bPlaying = false;

	Music_Title.value = getStatus();
}


//Options : Shuffle, Loop, ...
//ɼ : , ݺ  ɼ..
function mode( modeName )
{
	if ( player.settings.getMode( modeName ) )
	{
		player.settings.setMode( modeName, false);
		document[modeName].src = "../xemp/playerImg/" + modeName + "_off.jpg";
	}
	else
	{
		player.settings.setMode( modeName, true);
		document[modeName].src = "../xemp/playerImg/" + modeName + "_on.jpg";
	}

	if ( bPlaying )
		play();
	else
		stop();
}

//volume :  Լ (Volume Control)
function volume( up )
{
	if ( up )
		player.settings.volume++;
	else
		player.settings.volume--;
}

//loadList : ÷ Ʈ ҷ
function loadList( list )
{
	// Retrieve a PlaylistArray object that contains 
	// exactly one Playlist object.
	var plarray = player.playlistCollection.getByName( list );

	// Get the Playlist object from the PlaylistArray object.
	// The Playlist object has index number zero.
	var pl = plarray.item(0);

	// Make the retrieved playlist the current playlist.
	player.currentPlaylist = pl;

	return plarray;
}