/**
 * 
 * @author Hahm Myung Sun (hms1475@gmail.com)
 *
 * Copyright (c) 2011 JinoTech (http://www.jinotech.com) 
 * Licensed under the LGPL v3.0 license (http://www.gnu.org/licenses/lgpl.html).
 */

///////////////////////////////////////////////////////////////////////////////
/////////////////////////// jNodeControlleriPhone ///////////////////////////////////
///////////////////////////////////////////////////////////////////////////////


jNodeControlleriPhone = function(){
	jNodeControlleriPhone.superclass.call(this);
}

extend(jNodeControlleriPhone, jNodeController);
jNodeControlleriPhone.prototype.type = "jNodeControlleriPhone";

// JinoController의 addEvent를 보면 
// ... e = e.targetTouches[i]; e.originalEvent = olde; ... 와 같이
// targetTouches를 e로 놓고 e를 대체하고 있다.
// 따라서 아래 mousedown의 e는 targetTouches이 되어야 한다. 하지만 안된다.
// 그 이유는 if (e.targetTouches[i].target == obj)와 같이 target과 마우스를 클릭한 obj가 같은 경우에만 해당되는데,
// 노드를 클릭하면 svgRect 혹은 svgText가 obj가 되기 때문이다.
// (참고로 target은 'svgG - 그룹' 이다. jNode Events에서 addEvent할 때 group으로 했기 때문)
// 따라서 e는 결국 targetTouches로 대체되지 않은 순순한 event이다.
// 경우에 따라서 대체된 것이 올수 있으므로 e 변수를 사용할때는 (e.originalEvent || e)와 같이 사용하면 된다.
jNodeControlleriPhone.prototype.mousedown = function(e){
	(e.originalEvent || e).preventDefault();	
	var selectedNodes = jMap.getSelecteds();
	
	// 노드 하일라이팅
	if (e.ctrlKey){
		if(selectedNodes.contains(this))
			this.blur();
		else this.focus(false);	// control키 조합시 중복 선택
	} 
	else{
		if(!selectedNodes.contains(this)) {
			this.focus(true);
		}
	}
	
	
	
	
//	for (var i = 0, ii = e.targetTouches && e.targetTouches.length; i < ii; i++) {
//		console.log(i + " : " + e.targetTouches[i]);
//	}	
	
	
	
//	for(var a in (e.originalEvent || e).targetTouches[0])
//		console.log( a + " : " + (e.originalEvent || e).targetTouches[0][a])
//		
//	console.log("---------------------------------------------------------------------------------------------------")
//	
//	for(var a in (e.originalEvent || e))
//		console.log( a + " : " + (e.originalEvent || e).targetTouches[0][a])
	
	
	// 폴딩
//	if (this.isFoldingHit((e.originalEvent || e).targetTouches[0])) {
//		// Folding & unFolding
//		this.setFolding(!this.folded);
//		jMap.layoutManager.updateTreeHeightsAndRelativeYOfDescendants(this);				
//		jMap.layoutManager.updateTreeHeightsAndRelativeYOfAncestors(this);
//		jMap.layoutManager.layout(true);
//	}
}

jNodeControlleriPhone.prototype.mouseup = function(e){
	(e.originalEvent || e).preventDefault();
	
	// 움직이는 노드를 놓았을 때
	if (jMap.movingNode && !jMap.movingNode.removed) {
		var srcNodes = jMap.positionChangeNodes;
		var targNode = this;
		
		if (srcNodes && !srcNodes.contains(targNode)) {
			jMap.movingNode.connection && jMap.movingNode.connection.line.remove();
			jMap.movingNode.remove();
			
			// 자식 밑으로 옮기는지 체크. 그렇다면 무시..
			for (var i = 0; i < srcNodes.length; i++) {
				if (srcNodes[i].hadChildren(targNode)) {
					removeGradient(targNode);
					//targNode.body.animate({"fill-opacity": 0}, 500);
					jMap.positionChangeNodes = false;
					return;
				}
			}
			
			var offsetX = (e.offsetX) ? e.offsetX : e.layerX - this.getLocation().x;
			var widthHalf = this.body.getBBox().width / 2;
			//var pos = (this.isLeft()) ? (offsetX > widthHalf) : (offsetX < widthHalf);
			var isleftPos = (offsetX < widthHalf);
			
			// 노드를 자식으로 옮기는 함수
			var toChild = function() {
				
				var position = null;
				if (targNode.isRootNode()) 
					position = isleftPos ? "left" : "right";
				
				jMap.changePosition(targNode, srcNodes, position);
				
			}
			// 노드를 형제로 옮기는 함수
			var toSibling = function() {
				
				var position = null;
				if (targNode.getParent().isRootNode()) 
					position = targNode.position;
				var nextSibling = targNode.nextSibling();
				
				jMap.changePosition(targNode.getParent(), srcNodes, position, targNode);
				
			}
			
			if (srcNodes) {
				if (targNode.isRootNode()) {
					toChild();
				} else {
					switch(jMap.layoutManager.type) {
						case "jMindMapLayout" :
							if(this.isLeft()){
								isleftPos? toChild():toSibling();
							} else {
								isleftPos? toSibling():toChild();
							}	
							break;
						case "jTreeLayout" :
							isleftPos? toSibling():toChild();
							break;
						default :			
					}
				}
			}
			
			removeGradient(targNode);
			jMap.initFolding(targNode);
			jMap.layoutManager.updateTreeHeightsAndRelativeYOfWholeMap();
			//		jMap.layoutManager.updateTreeHeightsAndRelativeYOfDescendants(targNode.isRootNode()? targNode : targNode.parent);
			jMap.layoutManager.layout(true);
			targNode.focus(true);
		}
		
		jMap.positionChangeNodes = false;
	}
}

jNodeControlleriPhone.prototype.mousemove = function(e){
	(e.originalEvent || e).preventDefault();
	
}

jNodeControlleriPhone.prototype.click = function(e){
	(e.originalEvent || e).preventDefault();
	
	// 노드의 끝쪽 부분을 클릭하면 폴딩 및 언폴딩	
	if (this.isFoldingHit(e)) {
		// Folding & unFolding
		this.setFolding(!this.folded);
		jMap.layoutManager.updateTreeHeightsAndRelativeYOfDescendants(this);				
		jMap.layoutManager.updateTreeHeightsAndRelativeYOfAncestors(this);
		jMap.layoutManager.layout(true);
	}
}


