{
   This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
unit Ufrmwebviewer;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Buttons, StdCtrls, ComCtrls, ExtDlgs, shellapi, Spin;

type
  Tfrmwebviewer = class(TForm)
    Edit1: TEdit;
    Button1: TButton;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Edit2: TEdit;
    ProgressBar1: TProgressBar;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Edit3: TEdit;
    Button2: TButton;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    SpinEdit1: TSpinEdit;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    procedure BitBtn1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    { Private declarations }
    procedure WndProc(var Message: TMessage); override;
    procedure makewebviewerOnTerminate(Sender: TObject);
  public
    { Public declarations }
  end;

var
  frmwebviewer: Tfrmwebviewer;

implementation
uses Umain_hlp, Uconfig, Ufunction, Udialog, Ufrmmain;
{$R *.dfm}

procedure Tfrmwebviewer.WndProc(var Message: TMessage);
begin
  with Message do
    case Msg of
      wm_progress:begin
        ProgressBar1.Max:=wparam;
        ProgressBar1.Position:=lparam;
        label1.Caption:=format('%d/%d',[lparam,wparam]);
      end;
      wm_message:begin
        label3.Caption:=pchar(wparam);
      end;
    end;
  inherited;
end;

procedure Tfrmwebviewer.BitBtn1Click(Sender: TObject);
var
  s,s1,s2:String;
begin
  if (CheckBox2.Enabled) and (CheckBox2.Checked) then
  else begin
    s:=trim(edit1.Text);
    if s='' then begin
      MessageDlg(' ̹   ּ.', mterror, [mbok], 0);
      exit;
    end;
    if sysutils.FileExists(s)=false then begin
      MessageDlg(' ̹   ʽϴ.', mterror, [mbok], 0);
      exit;
    end;
  end;
  
  s2:=trim(edit3.Text);
  if (sysutils.DirectoryExists(s2)=false) and (sysutils.ForceDirectories(s2)=false) then begin
    MessageDlg('   ּ.', mterror, [mbok], 0);
    exit;
  end;

  s1:=trim(edit2.Text);
  if s1='' then begin
    MessageDlg('  ּ.', mterror, [mbok], 0);
    exit;
  end;

  if s2[length(s2)]<>'\' then s2:=s2+'\';
  if sysutils.DirectoryExists(s2+s1) then begin
    if MessageDlg(format('"%s"  ̹ մϴ.',[s2+s1])+#13#10+' ðڽϱ?',
        mtConfirmation, [mbYes, mbNo], 0)<>mryes then
      exit;
  end;

  config.c_webviewer_srcfile:=edit1.Text;
  config.c_webviewer_destfolder:=edit3.Text;
  config.c_webviewer_title:=edit2.Text;
  config.c_webviewer_thumbsize:=self.SpinEdit1.Value;  

  BitBtn1.Enabled:=false;
  BitBtn2.Enabled:=true;
  self.ProgressBar1.Position:=0;

  makewebviewer:=Tmakewebviewer.CreateThread;
  makewebviewer.srcfilename:=s;
  makewebviewer.title:=s1;
  makewebviewer.destfolder:=s2;
  makewebviewer.formhandle:=handle;
  makewebviewer.thumbsize:=SpinEdit1.Value;
  makewebviewer.skiptile:=self.CheckBox1.Checked;
  if CheckBox2.Enabled and CheckBox2.Checked then
    makewebviewer.srcbitmap:=frmmain.image2.Bitmap;
  makewebviewer.OnTerminate:=makewebviewerOnTerminate;
  makewebviewer.Resume;
end;

procedure Tfrmwebviewer.makewebviewerOnTerminate(Sender: TObject);
var
  wnd:integer;
begin
  BitBtn1.Enabled:=true;
  BitBtn2.Enabled:=false;
  if makewebviewer.htmlurl<>'' then begin
    if MessageDlg(' html    ðڽϱ?', mtConfirmation, [mbYes, mbNo], 0)=mryes then begin
      wnd:=OpenURLByIE(makewebviewer.htmlurl,false,true);
      if wnd=0 then
        ShellExecute(0, 'open', pchar(makewebviewer.htmlurl), nil, nil, SW_SHOW);
    end;
  end else  if makewebviewer.errmsg<>'' then begin
    if pos('Can''t allocate the DIB handle',makewebviewer.errmsg)>0 then
      MessageDlg(makewebviewer.errmsg+#13#10#13#10+
      '̹ Ҵϱ⿡ ޸𸮰   ϴ.'
      +#13#10+' ̹ ʹ ū ̰ų'
      +#13#10+'α׷ ε ̹ ִٸ α׷ ܿ "̹  " ޴  ٽ õ ñ ٶϴ.',
         mterror, [mbok], 0)
    else
      MessageDlg(mosaicwork.errmsg, mterror, [mbok], 0);
  end;
end;

procedure Tfrmwebviewer.Button1Click(Sender: TObject);
var
  OpenPictureDialog1:TmyOpenPictureDialog;
begin
OpenPictureDialog1:=TmyOpenPictureDialog.Create(self);
try
  OpenPictureDialog1.Filter:='jpg |*.jpg';
  OpenPictureDialog1.ExtraCheckbox.Checked:=config.c_dialog_preview;
  if edit1.Text='' then begin
    if config.c_lastdir='' then
      config.c_lastdir:=GetAppDirectory+'sample';
    OpenPictureDialog1.InitialDir:=config.c_lastdir;
  end else
    OpenPictureDialog1.FileName:=edit1.Text;
  if OpenPictureDialog1.Execute=false then exit;
  edit1.Text:=OpenPictureDialog1.FileName;
finally
  config.c_dialog_preview:=OpenPictureDialog1.ExtraCheckbox.Checked;
  OpenPictureDialog1.Free;
end;
end;

procedure Tfrmwebviewer.BitBtn2Click(Sender: TObject);
begin
  if makewebviewer<>nil then begin
    makewebviewer.Terminate;
    makewebviewer.WaitFor;
    freeandnil(makewebviewer);
  end;
end;

procedure Tfrmwebviewer.FormCreate(Sender: TObject);
begin
  edit1.Text:=config.c_webviewer_srcfile;
  edit3.Text:=config.c_webviewer_destfolder;
  edit2.Text:=config.c_webviewer_title;
  self.SpinEdit1.Value:=config.c_webviewer_thumbsize;
  self.CheckBox2.Enabled:=not frmmain.image2.Bitmap.Empty;
end;

procedure Tfrmwebviewer.Button2Click(Sender: TObject);
var
  Path:string;
begin
  Path:=edit3.Text;
  if path='' then begin
    path:=GetAppDirectory+'temp';
    sysutils.ForceDirectories(path);
  end;
  if AdvSelectDirectory(handle,'', '', Path, true, False, True)=false then
    exit;
  edit3.Text:=path;
end;

procedure Tfrmwebviewer.CheckBox2Click(Sender: TObject);
begin
  edit1.Enabled:=not CheckBox2.Checked;
  self.Button1.Enabled:=not CheckBox2.Checked;
end;

procedure Tfrmwebviewer.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  BitBtn2Click(nil);
end;

end.
