{
   This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
unit Ufrmresize;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Spin, Buttons, ComCtrls;

type
  Tfrmresize = class(TForm)
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    SpinEdit1: TSpinEdit;
    SpinEdit2: TSpinEdit;
    CheckBox1: TCheckBox;
    TypeCombo: TComboBox;
    CheckBox4: TCheckBox;
    Label4: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure SpinEdit1KeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure SpinEdit2KeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure BitBtn1Click(Sender: TObject);
  private
    { Private declarations }
    orgwidth,orgheight:integer;
    lastfilename:string;
  public
    { Public declarations }
  end;

var
  frmresize: Tfrmresize;

implementation
uses Ufrmmain, Ufrmsaveopt, Uconfig, Udialog, Ufunction,
  FreeBitmap, FreeImage, FreeUtils;
{$R *.dfm}

procedure Tfrmresize.FormCreate(Sender: TObject);
begin
  CheckBox1.Checked:=config.c_resize_keepratio;
  TypeCombo.ItemIndex:=config.c_resize_method;
  CheckBox2.Checked:=boolean(config.getvaluebyinteger('config_saveas_convert24bit',0));
  CheckBox3.Checked:=boolean(config.getvaluebyinteger('config_saveas_removetrans',0));
  lastfilename:='';
end;

procedure Tfrmresize.FormDestroy(Sender: TObject);
begin
  config.c_resize_keepratio:=CheckBox1.Checked;
  config.c_resize_method:=TypeCombo.ItemIndex;
  config.setvaluebyinteger('config_saveas_convert24bit',integer(CheckBox2.Checked));
  config.setvaluebyinteger('config_saveas_removetrans',integer(CheckBox3.Checked));
end;

procedure Tfrmresize.FormShow(Sender: TObject);
begin
  orgwidth:=SpinEdit1.Value;
  orgheight:=SpinEdit2.Value;
end;

procedure Tfrmresize.SpinEdit1KeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if CheckBox1.Checked then
    SpinEdit2.Value:=round(SpinEdit1.Value*orgheight / orgwidth);
end;

procedure Tfrmresize.SpinEdit2KeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if CheckBox1.Checked then
    SpinEdit1.Value:=round(SpinEdit2.Value*orgwidth / orgheight);
end;

procedure Tfrmresize.BitBtn1Click(Sender: TObject);
var
  s,ext:string;
  FBitmap:TFreeWinBitmap;
  sfilter:TFreeStretchFilter;
  FreeMemoryIO1:TFreeMemoryIO;
  stream:tmemorystream;
  flag:boolean;
  selectsaveflag:integer;

  resize:boolean;
  resize_width,resize_height:integer;
  convert24bit,removetrans:boolean;
label reopendialog;
begin
  resize:=CheckBox4.Checked;
  resize_width:=SpinEdit1.Value;
  resize_height:=SpinEdit2.Value;
  convert24bit:=CheckBox2.Checked;
  removetrans:=CheckBox3.Checked;
  sfilter:=TFreeStretchFilter(TypeCombo.ItemIndex);

  if lastfilename<>'' then
    s:=lastfilename
  else
    s:=currentimage.name;

  SaveDialog1.Filter:=FIU_GetAllFilters2;
  SaveDialog1.FilterIndex:=FIU_GetSelectidx(lowercase(ExtractFileExt(s)));
  if config.c_uselastdir then
    SaveDialog1.InitialDir:=config.lastdir
  else
    SaveDialog1.InitialDir:=ExtractFilePath(s);
  SaveDialog1.FileName:=ChangeFileExt(ExtractFileName(s),'');
  SaveDialog1.enablesaveopt:=true;

reopendialog:
  if SaveDialog1.Execute=false then exit;

  ext:=FIU_GetSelectExt(SaveDialog1.FilterIndex);
  selectsaveflag:=get_reg_saveopt_flag(FIU_GetFIFType2(ext),false);

  if pos(lowercase('*'+ExtractFileExt(SaveDialog1.FileName)+';'),
      lowercase(FIU_GetSelectExtfull(SaveDialog1.FilterIndex)))=0 then
    s:=sysutils.ChangeFileExt(SaveDialog1.FileName,ext)
  else
    s:=SaveDialog1.FileName;
  config.lastdir:=sysutils.ExtractFilePath(s);
  lastfilename:=s;

    if sysutils.FileExists(s) then begin
      if MessageDlg(format('"%s"  ̹ մϴ.',[ExtractFileName(s)])+#13#10+' ðڽϱ?',
           mtConfirmation, [mbYes, mbNo], 0)<>mrYes then
       goto reopendialog;
    end;

    FBitmap:=TFreeWinBitmap.Create;
    stream:=tmemorystream.Create;
    try
      frmmain.imgview321.Bitmap.SaveToStream(stream);
      FreeMemoryIO1:=TFreeMemoryIO.Create(stream.Memory,stream.Size);
      try
        if FBitmap.LoadFromMemory(FreeMemoryIO1)=false then begin
          s:=format('%s   ϴ.',[ExtractFileName(currentimage.name)]);
          MessageDlg(s, mtError, [mbOk], 0);
          exit;
        end;
      finally
        FreeMemoryIO1.Free;
      end;

      if resize then
        FBitmap.Rescale(resize_width,resize_height,sfilter);

      if comparetext(ExtractFileExt(s),'.gif')=0 then begin
        if FBitmap.IsTransparent then
          FBitmap.SetTransparentBg(nil);
        FBitmap.ConvertTo24Bits;
        FBitmap.ColorQuantize(FIQ_WUQUANT);
      end else begin
        if removetrans and FBitmap.IsTransparent then
          FBitmap.SetTransparentBg(nil);
        if convert24bit and (FBitmap.GetBitsPerPixel>24) then
          FBitmap.ConvertTo24Bits;
      end;

      flag:=FBitmap.Save(s,selectsaveflag);
      if flag=false then begin
        if FBitmap.IsTransparent then
          FBitmap.SetTransparentBg(nil);
        FBitmap.ConvertTo24Bits;
        flag:=FBitmap.Save(s,selectsaveflag);
      end;
      if flag then
        MessageDlg('Ǿϴ.',mtInformation, [mbOk], 0)
      else
        MessageDlg('忡 Ͽϴ.', mtError, [mbOk], 0);
    finally
      FBitmap.Free;
      stream.Free;
    end;
end;

end.
