{
   This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}

unit Ufrmgif;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, gifimage, StdCtrls, ExtCtrls, Buttons, Menus, clipbrd;

type
  Tfrmgif = class(TForm)
    Image2: TImage;
    Panel1: TPanel;
    ComboBox1: TComboBox;
    BitBtn1: TBitBtn;
    PopupMenu1: TPopupMenu;
    N1: TMenuItem;
    N2: TMenuItem;
    procedure FormShow(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure N1Click(Sender: TObject);
    procedure N2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    gif:tgifimage;
  end;

var
  frmgif: Tfrmgif;

implementation
uses Ufrmmain, Ufrmextract;
{$R *.dfm}

procedure Tfrmgif.FormShow(Sender: TObject);
var
  i,w,h,w2,h2:integer;
  pt:tpoint;
begin
  ComboBox1.Items.Clear;
  for i:=0 to gif.Images.Count-1 do begin
    self.ComboBox1.Items.Add(format('%d ̹',[i+1]))
  end;
  w:=gif.Width;
  h:=gif.Height;

//  w:=3000;
//  h:=round(w*gif.Height/gif.Width);

  self.ClientWidth:=w;
  if self.ClientWidth<263 then self.ClientWidth:=263;
  self.ClientHeight:=h+panel1.Height;

  if Width>screen.WorkAreaWidth then begin
    Width:=screen.WorkAreaWidth;
    h2:=round(ClientWidth*gif.Height/gif.Width);
    self.ClientHeight:=h2+panel1.Height;
  end;
  if Height>screen.WorkAreaHeight then begin
    Height:=screen.WorkAreaHeight;
    w2:=round((ClientHeight-panel1.Height)*gif.Width/gif.Height);
    self.ClientWidth:=w2;
  end;

  image2.Left:=0;
  image2.Top:=panel1.Height;
  image2.Width:=w;
  image2.Height:=h;

  ComboBox1.ItemIndex:=0;
  ComboBox1Change(nil);

  pt:=frmmain.panelgif.ClientToScreen(point(0,0));
  Left:=pt.X;
  Top:=(pt.Y+frmmain.panelgif.Height)-self.Height;

  if left<screen.WorkAreaRect.Left then left:=screen.WorkAreaRect.Left;
  if Top<screen.WorkAreaRect.Top then Top:=screen.WorkAreaRect.Top;
  if left+width>screen.WorkAreaRect.Right then left:=screen.WorkAreaRect.Right-width;
  if Top+Height>screen.WorkAreaRect.Bottom then Top:=screen.WorkAreaRect.Bottom-Height;
end;

procedure Tfrmgif.ComboBox1Change(Sender: TObject);
var
  w,h,l,t:integer;
begin
  w:=gif.Width;
  h:=gif.Height;
  l:=gif.Images.SubImages[ComboBox1.ItemIndex].Left;
  t:=gif.Images.SubImages[ComboBox1.ItemIndex].Top;

  image2.Picture.Bitmap.Width:=w;
  image2.Picture.Bitmap.Height:=h;
  image2.Picture.Bitmap.Canvas.Brush.Color:=clbtnface;
  image2.Picture.Bitmap.Canvas.FillRect(rect(0,0,w,h));
  image2.Picture.Bitmap.Canvas.Draw(l,t,gif.Images.SubImages[ComboBox1.ItemIndex].Bitmap);
end;

procedure Tfrmgif.N1Click(Sender: TObject);
begin
  clipboard.Assign(gif.Images.SubImages[ComboBox1.ItemIndex].Bitmap);
end;

procedure Tfrmgif.N2Click(Sender: TObject);
begin
  frmextract:=Tfrmextract.Create(self);
  try
    frmextract.gif:=self.gif;
    frmextract.Edit1.Text:=ChangeFileExt(ExtractFileName(currentimage.name),'')+'_';
    frmextract.Caption:=format('%s (%d ̹)',[(Sender as tmenuitem).Caption,gif.Images.Count]);
    frmextract.extracttype:=extgif;
    frmextract.ShowModal;
  finally
    frmextract.Free;
  end;
end;

end.
