{

   This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
unit UfrmEffect_Contrast;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UfrmEffectBase, StdCtrls, Spin, ComCtrls, ExtCtrls, im_Basic;

type
  TfrmEffect_Contrast = class(TfrmEffectBase)
    Panel1: TPanel;
    TrackBar1: TTrackBar;
    Label3: TLabel;
    Label22: TLabel;
    Label1: TLabel;
    TrackBar3: TTrackBar;
    TrackBar2: TTrackBar;
    SpinEdit3: TSpinEdit;
    SpinEdit2: TSpinEdit;
    SpinEdit1: TSpinEdit;
    Button1: TButton;
    procedure TrackBar1Change(Sender: TObject);
    procedure TrackBar2Change(Sender: TObject);
    procedure TrackBar3Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure SpinEdit1Change(Sender: TObject);
  private
    { Private declarations }
    lastaction:integer;
    procedure set_effectapply;
    procedure ok_select; override;
    procedure imageprocess(var src:tbitmap);
  public
    { Public declarations }
  end;

var
  frmEffect_Contrast: TfrmEffect_Contrast;

implementation
uses Ufrmmain, Uconfig, Ufunction;
{$R *.dfm}

procedure TfrmEffect_Contrast.TrackBar1Change(Sender: TObject);
var contrast:real;
begin
  if lastaction=1 then imagepreview1.bitmap.Assign(thumb_bitmap32)
  else thumb_bitmap32.Assign(imagepreview1.bitmap);
  contrast:=Trackbar1.Position;
  im_basic.contrast(imagepreview1.bitmap,contrast/100);
  SpinEdit1.Text:=inttostr(round(Contrast));
  lastaction:=1;
end;

procedure TfrmEffect_Contrast.TrackBar2Change(Sender: TObject);
var brightness:real;
begin
  if lastaction=2 then imagepreview1.bitmap.Assign(thumb_bitmap32)
  else thumb_bitmap32.Assign(imagepreview1.bitmap);
  imagepreview1.bitmap.Assign(thumb_bitmap32);
  brightness:=Trackbar2.Position;
  im_basic.brightness(imagepreview1.bitmap,brightness/100);
  SpinEdit2.Text:=inttostr(round(Brightness));
  lastaction:=2;
end;

procedure TfrmEffect_Contrast.TrackBar3Change(Sender: TObject);
begin
  if lastaction=3 then imagepreview1.bitmap.Assign(thumb_bitmap32)
  else thumb_bitmap32.Assign(imagepreview1.bitmap);
  imagepreview1.bitmap.Assign(thumb_bitmap32);
  im_basic.gamma(imagepreview1.bitmap,Trackbar3.Position/100);
  SpinEdit3.Text:=inttostr(Trackbar3.Position);
  lastaction:=3;
end;

procedure TfrmEffect_Contrast.FormCreate(Sender: TObject);
begin
  inherited;
  Panel1.Align:=alclient;
  PanelPreView.Align:=alLeft;
  lastaction:=0;
end;

procedure TfrmEffect_Contrast.FormShow(Sender: TObject);
begin
  make_thumbimage;
  imagepreview1.Bitmap.Assign(thumb_bitmap32);
  applyselect.Visible:=not frmmain.is_layerselected;
end;

procedure TfrmEffect_Contrast.set_effectapply;
begin
  im_basic.contrast(org_bitmap32,Trackbar1.Position/100);
  im_basic.brightness(org_bitmap32,Trackbar2.Position/100);
  im_basic.gamma(org_bitmap32,Trackbar3.Position/100);
end;

procedure TfrmEffect_Contrast.ok_select;
begin
  config.setvaluebyinteger('contrast_value1',Trackbar1.Position);
  config.setvaluebyinteger('contrast_value2',Trackbar2.Position);
  config.setvaluebyinteger('contrast_value3',Trackbar3.Position);

  if applyselect.ItemIndex=0 then begin
    Screen.Cursor:=crHourglass;
    try
      set_effectapply;
      imagepreview1.Bitmap.Assign(org_bitmap32);
    finally
      screen.Cursor:=crdefault;
    end;
    exit;
  end;

  frmmain.apply_listimages(applyselect.ItemIndex=1,imageprocess,etContrast,self.Caption);
  self.ModalResult:=mrcancel;
end;

procedure TfrmEffect_Contrast.imageprocess(var src:tbitmap);
begin
  org_bitmap32.Assign(src);
  set_effectapply;
  org_bitmap32.AssignTo24(src);
end;

procedure TfrmEffect_Contrast.Button1Click(Sender: TObject);
begin
  config.getvaluebyinteger('contrast_value1',0);
  Trackbar1.Position:=config.lastvalue_integer;
  config.getvaluebyinteger('contrast_value2',0);
  Trackbar2.Position:=config.lastvalue_integer;
  config.getvaluebyinteger('contrast_value3',100);
  Trackbar3.Position:=config.lastvalue_integer;
end;

procedure TfrmEffect_Contrast.SpinEdit1Change(Sender: TObject);
begin
  if isvalidinteger(SpinEdit1.Text) then trackbar1.Position:=round(SpinEdit1.Value);
  if isvalidinteger(SpinEdit2.Text) then trackbar2.Position:=round(SpinEdit2.Value);
  if isvalidinteger(SpinEdit3.Text) then trackbar3.Position:=round(SpinEdit3.Value);
end;

end.
