/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.swrc.jhannanum.share;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;

public class Code {
    public static final int ENCODING_TRIPLE = 0;
    public static final int ENCODING_UNICODE = 1;
    public static final int JAMO_CHOSEONG = 0;
    public static final int JAMO_JUNGSEONG = 1;
    public static final int JAMO_JONGSEONG = 2;
    public static final char HANGUL_FILLER = '\u3164';
    private static final char[] CHOSEONG_LIST = new char[]{'\u3131', '\u3132', '\u3134', '\u3137', '\u3138', '\u3139', '\u3141', '\u3142', '\u3143', '\u3145', '\u3146', '\u3147', '\u3148', '\u3149', '\u314a', '\u314b', '\u314c', '\u314d', '\u314e'};
    private static final char[] JONGSEONG_LIST = new char[]{'\u3164', '\u3131', '\u3132', '\u3133', '\u3134', '\u3135', '\u3136', '\u3137', '\u3139', '\u313a', '\u313b', '\u313c', '\u313d', '\u313e', '\u313f', '\u3140', '\u3141', '\u3142', '\u3144', '\u3145', '\u3146', '\u3147', '\u3148', '\u314a', '\u314b', '\u314c', '\u314d', '\u314e'};
    private static final byte[] CHOSEONG_LIST_REV;
    private static final byte[] JONGSEONG_LIST_REV;

    static {
        byte[] byArray = new byte[30];
        byArray[1] = 1;
        byArray[2] = -1;
        byArray[3] = 2;
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = 3;
        byArray[7] = 4;
        byArray[8] = 5;
        byArray[9] = -1;
        byArray[10] = -1;
        byArray[11] = -1;
        byArray[12] = -1;
        byArray[13] = -1;
        byArray[14] = -1;
        byArray[15] = -1;
        byArray[16] = 6;
        byArray[17] = 7;
        byArray[18] = 8;
        byArray[19] = -1;
        byArray[20] = 9;
        byArray[21] = 10;
        byArray[22] = 11;
        byArray[23] = 12;
        byArray[24] = 13;
        byArray[25] = 14;
        byArray[26] = 15;
        byArray[27] = 16;
        byArray[28] = 17;
        byArray[29] = 18;
        CHOSEONG_LIST_REV = byArray;
        JONGSEONG_LIST_REV = new byte[]{1, 2, 3, 4, 5, 6, 7, -1, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, -1, 18, 19, 20, 21, 22, -1, 23, 24, 25, 26, 27};
    }

    public static void convertFile(String srcFileName, String desFileName, int srcEncoding, int desEncoding) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(srcFileName), "UTF-8"));
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(desFileName), "UTF-8"));
        String line = null;
        if (srcEncoding == 1 && desEncoding == 0) {
            while ((line = br.readLine()) != null) {
                char[] buf = Code.toTripleArray(line);
                bw.write(buf);
                bw.write(10);
            }
        } else if (srcEncoding == 0 && desEncoding == 1) {
            while ((line = br.readLine()) != null) {
                String buf = Code.toString(line.toCharArray());
                bw.write(buf);
                bw.write(10);
            }
        }
        br.close();
        bw.close();
    }

    public static boolean isChoseong(char c) {
        return c >= '\u1100' && c <= '\u1112';
    }

    public static boolean isJongseong(char c) {
        return c >= '\u11a8' && c <= '\u11c2';
    }

    public static boolean isJungseong(char c) {
        return c >= '\u1161' && c <= '\u1175';
    }

    public static void main(String[] args) {
        try {
            Code.convertFile("data/src/Exp.java", "data/src/Exp1.java", 1, 0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static char toChoseong(char jongseong) {
        if (jongseong >= '\u11a8' && jongseong <= '\u11c2') {
            jongseong = (char)(jongseong - 4519);
            char tmp = JONGSEONG_LIST[jongseong];
            if (CHOSEONG_LIST_REV[tmp = (char)(tmp - 12593)] != -1) {
                return (char)(CHOSEONG_LIST_REV[tmp] + 4352);
            }
        }
        return jongseong;
    }

    public static char toCompatibilityJamo(char jamo) {
        if (jamo >= '\u1100' && jamo < 4352 + CHOSEONG_LIST.length) {
            return CHOSEONG_LIST[jamo - 4352];
        }
        if (jamo >= '\u1161' && jamo <= '\u1175') {
            return (char)(jamo - 4449 + 12623);
        }
        if (jamo == '\u0000') {
            return '\u3164';
        }
        if (jamo >= '\u11a8' && jamo < 4519 + JONGSEONG_LIST.length) {
            return JONGSEONG_LIST[jamo - 4519];
        }
        return jamo;
    }

    public static char toJamo(char jamo, int flag) {
        char result = '\u0000';
        switch (flag) {
            case 0: {
                if (jamo < '\u0000' || jamo > '\u0012') break;
                result = (char)(jamo + 4352);
                break;
            }
            case 1: {
                if (jamo < '\u0000' || jamo > '\u0014') break;
                result = (char)(jamo + 4449);
                break;
            }
            case 2: {
                if (jamo < '\u0001' || jamo > '\u001b') break;
                result = (char)(jamo + 4519);
            }
        }
        return result;
    }

    public static String toString(char[] tripleArray) {
        String result = "";
        int i = 0;
        int len = tripleArray.length;
        if (len == 0) {
            return "";
        }
        char c = tripleArray[i];
        while (i < len) {
            int jong;
            int jung;
            if (c >= '\u1100' && c <= '\u1112') {
                int cho = c - 4352;
                if (++i < len) {
                    c = tripleArray[i];
                }
                if (c >= '\u1161' && c <= '\u1175' && i < len) {
                    jung = c - 4449;
                    if (++i < len) {
                        c = tripleArray[i];
                    }
                    if (c >= '\u11a8' && c <= '\u11c2' && i < len) {
                        jong = c - 4519;
                        result = String.valueOf(result) + (char)(44032 + cho * 21 * 28 + jung * 28 + jong);
                        if (++i >= len) continue;
                        c = tripleArray[i];
                        continue;
                    }
                    result = String.valueOf(result) + (char)(44032 + cho * 21 * 28 + jung * 28);
                    continue;
                }
                char tmp = CHOSEONG_LIST[cho];
                if (tmp == '\u3143' || tmp == '\u3149' || tmp == '\u3138') {
                    result = String.valueOf(result) + CHOSEONG_LIST[cho];
                    continue;
                }
                result = String.valueOf(result) + "^" + CHOSEONG_LIST[cho];
                continue;
            }
            if (c >= '\u1161' && c <= '\u1175' && i < len) {
                jung = c - 4449;
                result = String.valueOf(result) + (char)(jung + 12623);
                if (++i >= len) continue;
                c = tripleArray[i];
                continue;
            }
            if (c >= '\u11a8' && c <= '\u11c2' && i < len) {
                jong = c - 4519;
                result = String.valueOf(result) + JONGSEONG_LIST[jong];
                if (++i >= len) continue;
                c = tripleArray[i];
                continue;
            }
            result = String.valueOf(result) + c;
            if (++i >= len) continue;
            c = tripleArray[i];
        }
        return result;
    }

    public static String toString(char[] tripleArray, int len) {
        String result = "";
        int i = 0;
        char c = tripleArray[i++];
        while (i < len) {
            int jong;
            int jung;
            if (c >= '\u1100' && c <= '\u1112' && i < len) {
                int cho = c - 4352;
                if ((c = tripleArray[i++]) >= '\u1161' && c <= '\u1175' && i < len) {
                    jung = c - 4449;
                    if ((c = tripleArray[i++]) >= '\u11a8' && c <= '\u11c2' && i < len) {
                        jong = c - 4519;
                        result = String.valueOf(result) + (char)(44032 + cho * 21 * 28 + jung * 28 + jong);
                        c = tripleArray[i++];
                        continue;
                    }
                    result = String.valueOf(result) + (char)(44032 + cho * 21 * 28 + jung * 28);
                    continue;
                }
                char tmp = CHOSEONG_LIST[cho];
                if (tmp == '\u3143' || tmp == '\u3149' || tmp == '\u3138') {
                    result = String.valueOf(result) + CHOSEONG_LIST[cho];
                    continue;
                }
                result = String.valueOf(result) + "^" + CHOSEONG_LIST[cho];
                continue;
            }
            if (c >= '\u1161' && c <= '\u1175' && i < len) {
                jung = c - 4449;
                result = String.valueOf(result) + (char)(jung + 12623);
                c = tripleArray[i++];
                continue;
            }
            if (c >= '\u11a8' && c <= '\u11c2' && i < len) {
                jong = c - 4519;
                result = String.valueOf(result) + JONGSEONG_LIST[jong];
                c = tripleArray[i++];
                continue;
            }
            result = String.valueOf(result) + c;
            c = tripleArray[i++];
        }
        return result;
    }

    public static char toSyllable(char cho, char jung, char jong) {
        if (cho >= '\u1100' && cho <= '\u1112') {
            cho = (char)(cho - 4352);
            if (jung >= '\u1161' && jung <= '\u1175') {
                jung = (char)(jung - 4449);
                if (jong >= '\u11a8' && jong <= '\u11c2') {
                    jong = (char)(jong - 4520);
                    return (char)(44032 + cho * 21 * 28 + jung * 28 + jong);
                }
                return (char)(44032 + cho * 21 * 28 + jung * 28);
            }
            return CHOSEONG_LIST[cho];
        }
        if (jung >= '\u1161' && jung <= '\u1175') {
            jung = (char)(jung - 4449);
            return (char)(jung + 12623);
        }
        if (jong >= '\u11a8' && jong <= '\u11c2') {
            jong = (char)(jong - 282);
            return JONGSEONG_LIST[jong];
        }
        return '\u3164';
    }

    public static char[] toTripleArray(String str) {
        char[] result = null;
        ArrayList<Character> charList = new ArrayList<Character>();
        char c = '\u0000';
        int i = 0;
        while (i < str.length()) {
            c = str.charAt(i);
            if (c >= '\uac00' && c <= '\ud7af') {
                char jong;
                char jung;
                int combined = c - 44032;
                char cho = Code.toJamo((char)(combined / 588), 0);
                if (cho != '\u0000') {
                    charList.add(Character.valueOf(cho));
                }
                if ((jung = Code.toJamo((char)((combined %= 588) / 28), 1)) != '\u0000') {
                    charList.add(Character.valueOf(jung));
                }
                if ((jong = Code.toJamo((char)(combined % 28), 2)) != '\u0000') {
                    charList.add(Character.valueOf(jong));
                }
            } else if (c >= '\u3131' && c <= '\u314e') {
                if (JONGSEONG_LIST_REV[c = (char)(c - 12593)] != -1) {
                    charList.add(Character.valueOf((char)(JONGSEONG_LIST_REV[c] + 4519)));
                } else if (CHOSEONG_LIST_REV[c] != -1) {
                    charList.add(Character.valueOf((char)(CHOSEONG_LIST_REV[c] + 4352)));
                } else {
                    charList.add(Character.valueOf((char)(c + 12593)));
                }
            } else if (c >= '\u314f' && c <= '\u3163') {
                charList.add(Character.valueOf((char)(c - 12623 + 4449)));
            } else if (c == '^' && str.length() > i + 1 && str.charAt(i + 1) >= '\u3131' && str.charAt(i + 1) <= '\u314e') {
                c = (char)(str.charAt(i + 1) - 12593);
                if (CHOSEONG_LIST_REV[c] != -1) {
                    charList.add(Character.valueOf((char)(CHOSEONG_LIST_REV[c] + 4352)));
                    ++i;
                } else {
                    charList.add(Character.valueOf('^'));
                }
            } else {
                charList.add(Character.valueOf(c));
            }
            ++i;
        }
        result = new char[charList.size()];
        Iterator iter = charList.iterator();
        int i2 = 0;
        while (i2 < result.length) {
            result[i2] = ((Character)iter.next()).charValue();
            ++i2;
        }
        return result;
    }

    public static String toTripleString(String str) {
        return String.valueOf(Code.toTripleArray(str));
    }
}

