/*  -
   Copyright (C) 2006 Weongyo Jeong (weongyo@gmail.com)

This file is part of ROVM.

ROVM is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.

ROVM is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.  */

#include <stdio.h>

#include "types.h"
#include "mpool.h"
#include "tktree.h"
#include "clstree.h"
#include "sha1.h"
#include "listen.h"
#include "rovm.h"

#include "thread.h"
#include "thread_mutex.h"
#include "thread_cond.h"

#include "mpm_worker_fdqueue.h"
#include "mpm_worker_pod.h"
#include "mpm_worker.h"

#include "utils.h"

#include "connection.h"
#include "request.h"
#include "proc_rc.h"
#include "ticket.h"

#include "log.h"

/**
   Request   unique key (ticket)  Ѵ.  ̿  
   TBUF   Ѵ.   ϵ request   ó غ ؾ
   Ѵ.

   @param r	Request ü.
   @return	߱޵ ticket  ͸ ȯѴ.
 */
char *
proc_rc_req (r)
     request_rec *r;
{
  char *tbuf;

  tbuf = create_ticketid (r);
  if (!tbuf)
    {
      request_add_error (r, ERRLOG_ERR, ERRLOG_MARK, "Failed to create Ticket ID.");
      return NULL;
    }

  /*  tbuf  Ѵ.  */
  if (register_ticketid (r, tbuf))
    {
      request_add_error (r, ERRLOG_ERR, ERRLOG_MARK, "Failed to register Ticket ID.");
      rc_free (tbuf);
      return NULL;
    }

  return tbuf;
}

/**
     Ticket ID  ؼ ׿ õ  ڿ Ѵ.

   @param r     Request ü
   @param tid    ǽ Ticket ID
   @return        0, ׷   -1  Բ error ޼.
 */
int
proc_rc_reqend (r, tid)
     request_rec *r;
     char *tid;
{
  if (destroy_tickets (r, tid))
    return -1;

  return 0;
}

/**
   Request   opcode  óѴ.   ϴ  ƹ 
    , COMMAND_OK  ȯϰ ȴ.

   @param r      Request ü
   @param tid    Request   ޵ ticket id
   @param op     Opcode  ִ 
   @param oplen  Opcode 
   @return          ϷǾٸ TICKET  Ͽ
                  TK  ȯѴ.  ̷ ϴ   Լ ȣ
                  opcode  ϰ   return ڵ带 ٷ 
                 ֵ ϱ ؼ ̴.
 */
struct ticket *
proc_rc_opcode (r, tid, op, oplen)
     request_rec *r;
     char *tid;
     rc_opcode_t *op;
     rc_size_t oplen;
{
  rc_status_t rv;
  struct ticket *tk;

  tk = lookup_ticket (r, tid);
  if (!tk)
    {
      request_add_error (r, ERRLOG_INFO, ERRLOG_MARK, "Invalid Ticket ID");
      return NULL;
    }

  if (ticket_pre_config (tk))
    return NULL;

  rv = rovmcore_main (r, tk, op, oplen);
  if (rv)
    return NULL;

  return tk;
}

/**
   ڰ TID    ¸ ûϿ , Ǵ ԼԴϴ.   
   ¸ Command `ERROR'   ڿ ϴ.   Լ  
   ̶  ˱ ٶϴ.

   @param r     Request ü
   @param tid   ڰ  TID
 */
void
proc_rc_getstack (r, tid)
     request_rec *r;
     char *tid;
{
  int idx = 0;
  rovm_stack_t *p;
  struct ticket *tk;

  tk = lookup_ticket (r, tid);
  if (!tk)
    {
      request_add_error (r, ERRLOG_INFO, ERRLOG_MARK, "Invalid Ticket ID");
      return;
    }

  p = TICKET_STACK (tk);
  while (p <= TICKET_SP (tk))
    {
      switch (STACK_TYPE (p))
        {
        case STACK_TYPE_CHAR:
          request_add_error (r, ERRLOG_DEBUG, ERRLOG_MARK, "#%d CHAR 0x%x", idx, STACK_V_CHAR (p));
          break;
        case STACK_TYPE_INT:
          request_add_error (r, ERRLOG_DEBUG, ERRLOG_MARK, "#%d INT 0x%x", idx, STACK_V_INT (p));
          break;
        case STACK_TYPE_OBJREF:
          request_add_error (r, ERRLOG_DEBUG, ERRLOG_MARK, "#%d OBJREF %p", idx, STACK_V_ADDR (p));
          break;
        default:
          rovm_rlog (r, ROVMLOG_WARNING, ROVMLOG_MARK,
                     "Can't handle stack type.");
        }

      idx += 1;
      p += 1;
    }
}

/**
   Remote Command   ˼  쿡 ȣǸ, ü R  
     ߻Ͽ Ѵ.

   @param r	Request ü.
   @param rc	 ߻ Remote Command.
 */
void
proc_rc_unknown (r, rc)
     request_rec *r;
     char rc;
{
  request_add_error (r, ERRLOG_ERR, ERRLOG_MARK, "Invalid Remote Command : rc = 0x%x", rc);
}
