/*  -
   Copyright (C) 2006 Weongyo Jeong (weongyo@gmail.com)

This file is part of ROVM.

ROVM is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.

ROVM is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.  */

#ifndef _ROVM_MPOLL_H
#define _ROVM_MPOLL_H

#define mp_strcat                       apr_pstrcat

extern rc_status_t mp_create (rc_pool_t **, rc_pool_t *);
extern rc_status_t mp_create_ex (rc_pool_t **,
                                 rc_pool_t *,
                                 rc_abortfunc_t,
                                 rc_allocator_t *);
extern void *mp_alloc (rc_pool_t *, size_t);
extern void *mp_calloc (rc_pool_t *, size_t);
extern void mp_tag (rc_pool_t *, const char *);
extern void mp_clear (rc_pool_t *);
extern void mp_cleanup_register (rc_pool_t *, const void *, 
                                 rc_status_t (*plain_cleanup) (void *), 
                                 rc_status_t (*child_cleanup) (void *));
extern int mp_destroy (rc_pool_t *);

extern rc_status_t rc_allocator_create (rc_allocator_t **);
extern void rc_allocator_owner_set (rc_allocator_t *, rc_pool_t *);

extern rc_status_t mp_userdata_set (const void *, const char *, rc_status_t (*cleanup)(void *), rc_pool_t *);
extern rc_status_t mp_userdata_get (void **, const char *, rc_pool_t *);

extern char * mp_strdup (rc_pool_t *p, const char *s);

#endif
