/// @file RenderQueueMaker.h
#ifndef RENDEQUEUERMAKER_H
#define RENDERQUEUEMAKER_H

#include "../core/process/RenderQueue.h"
#include "../model/ModelMaker.h"

/// @brief RenderQueue  Լ
class RenderQueueMaker {
	public:
		static RenderQueue* makeCubeQueue(RenderPocket& _refRenderPocket, TiXmlElement* _pRenderElement){
			RenderQueue* pRenderQueue = new RenderQueue;
			const char *pTextureName = _pRenderElement->Attribute("texture");
			int scale; _pRenderElement->Attribute("scale", &scale);
			Model* pModel = new Model;
			ModelMaker::createCubeModel(_refRenderPocket.getD3DDevice(), pModel, pTextureName, scale);
			pRenderQueue->pModel = pModel;
			_refRenderPocket.sortedModelObjectQueue.push_back(pRenderQueue);
			return pRenderQueue;
		}
		static RenderQueue* makeSpriteQueue(RenderPocket& _refRenderPocket, TiXmlElement* _pRenderElement){
			RenderQueue* pRenderQueue = new RenderQueue;
			const char *pTextureName = _pRenderElement->Attribute("texture");
			int w, h;
			_pRenderElement->Attribute("w", &w);
			_pRenderElement->Attribute("h", &h);
			Model* pModel = new Model;
			D3DXIMAGE_INFO d3dxImageInfo;
			D3DXCreateTextureFromFileEx( _refRenderPocket.getD3DDevice(), pTextureName,
				w, // ؽ ǥ  
				h, // ؽ ǥ  
				1,   // Ʈ 쿡 Ӹ  ʴ´.
				D3DPOOL_DEFAULT,D3DFMT_UNKNOWN, D3DPOOL_DEFAULT, D3DX_DEFAULT,D3DX_DEFAULT,
				D3DCOLOR_COLORVALUE(1.0f,0.0f,1.0f,1.0f), //color key
				&d3dxImageInfo, NULL, &pModel->pTexture);
			pRenderQueue->pModel = pModel;
			_refRenderPocket.sortedSpriteObjectQueue.push_back(pRenderQueue);
			return pRenderQueue;
		}	
};
#endif