#include "ModelMaker.h"

void ModelMaker::createCubeModel(LPDIRECT3DDEVICE9 _pD3DDevice, Model* _pModel, const char* _pTextureName, const int _scale){

	int _width, _height, _depth;
	_width = _height = _depth = _scale;

	_pModel->numVertices = 24;
	_pModel->numPolygons = 12;

	//Set values for VB
	CustomVertex aCubeVertices[] = {	
		//Top Face
		{0.0f - (_width / 2), 0.0f + (_height / 2), 0.0f - (_depth / 2), 0.0f, 1.0f,}, //Vertex 0
		{0.0f - (_width / 2), 0.0f + (_height / 2), 0.0f + (_depth / 2), 0.0f, 0.0f,}, //Vertex 1
		{0.0f + (_width / 2), 0.0f + (_height / 2), 0.0f - (_depth / 2), 1.0f, 1.0f,}, //Vertex 2
		{0.0f + (_width / 2), 0.0f + (_height / 2), 0.0f + (_depth / 2), 1.0f, 0.0f,}, //Vertex 3
		//Face 1
		{0.0f - (_width / 2), 0.0f - (_height / 2), 0.0f - (_depth / 2), 0.0f, 1.0f,}, //Vertex 4
		{0.0f - (_width / 2), 0.0f + (_height / 2), 0.0f - (_depth / 2), 0.0f, 0.0f,}, //Vertex 5
		{0.0f + (_width / 2), 0.0f - (_height / 2), 0.0f - (_depth / 2), 1.0f, 1.0f,}, //Vertex 6
		{0.0f + (_width / 2), 0.0f + (_height / 2), 0.0f - (_depth / 2), 1.0f, 0.0f,}, //Vertex 7
		//Face 2
		{0.0f + (_width / 2), 0.0f - (_height / 2), 0.0f - (_depth / 2), 0.0f, 1.0f,}, //Vertex 8
		{0.0f + (_width / 2), 0.0f + (_height / 2), 0.0f - (_depth / 2), 0.0f, 0.0f,}, //Vertex 9
		{0.0f + (_width / 2), 0.0f - (_height / 2), 0.0f + (_depth / 2), 1.0f, 1.0f,}, //Vertex 10
		{0.0f + (_width / 2), 0.0f + (_height / 2), 0.0f + (_depth / 2), 1.0f, 0.0f,}, //Vertex 11
		//Face 3
		{0.0f + (_width / 2), 0.0f - (_height / 2), 0.0f + (_depth / 2), 0.0f, 1.0f,}, //Vertex 12
		{0.0f + (_width / 2), 0.0f + (_height / 2), 0.0f + (_depth / 2), 0.0f, 0.0f,}, //Vertex 13
		{0.0f - (_width / 2), 0.0f - (_height / 2), 0.0f + (_depth / 2), 1.0f, 1.0f,}, //Vertex 14
		{0.0f - (_width / 2), 0.0f + (_height / 2), 0.0f + (_depth / 2), 1.0f, 0.0f,}, //Vertex 15
		//Face 4
		{0.0f - (_width / 2), 0.0f - (_height / 2), 0.0f + (_depth / 2), 0.0f, 1.0f,}, //Vertex 16
		{0.0f - (_width / 2), 0.0f + (_height / 2), 0.0f + (_depth / 2), 0.0f, 0.0f,}, //Vertex 17
		{0.0f - (_width / 2), 0.0f - (_height / 2), 0.0f - (_depth / 2), 1.0f, 1.0f,}, //Vertex 18
		{0.0f - (_width / 2), 0.0f + (_height / 2), 0.0f - (_depth / 2), 1.0f, 0.0f,}, //Vertex 19
		//Bottom Face
		{0.0f + (_width / 2), 0.0f - (_height / 2), 0.0f - (_depth / 2), 0.0f, 1.0f,}, //Vertex 20
		{0.0f + (_width / 2), 0.0f - (_height / 2), 0.0f + (_depth / 2), 0.0f, 0.0f,}, //Vertex 21
		{0.0f - (_width / 2), 0.0f - (_height / 2), 0.0f - (_depth / 2), 1.0f, 1.0f,}, //Vertex 22
		{0.0f - (_width / 2), 0.0f - (_height / 2), 0.0f + (_depth / 2), 1.0f, 0.0f,}, //Vertex 23
	};

	//Set values for IB
	short aCubeIndices[] = { 0, 1, 2, 3, 2, 1,	//Top
							 4, 5, 6, 7, 6, 5,	//Face 1
							 8, 9,10,11,10, 9,	//Face 2
							12,13,14,15,14,13,	//Face 3
							16,17,18,19,18,17,	//Face 4
							20,21,22,23,22,21};	//Bottom

	_pD3DDevice->CreateVertexBuffer(sizeof(aCubeVertices),D3DUSAGE_WRITEONLY,D3DFVF_CustomVertex,D3DPOOL_MANAGED,&_pModel->pVB,NULL);
	_pD3DDevice->CreateIndexBuffer(sizeof(aCubeIndices),D3DUSAGE_WRITEONLY,D3DFMT_INDEX16,D3DPOOL_MANAGED,&_pModel->pIB,NULL);
	
	void* pData;
	_pModel->pVB->Lock(0,sizeof(pData),(void**)&pData,0);
	memcpy(pData,aCubeVertices,sizeof(aCubeVertices));
	_pModel->pVB->Unlock();

	_pModel->pIB->Lock(0,sizeof(pData),(void**)&pData,0);
	memcpy(pData,aCubeIndices,sizeof(aCubeIndices));
	_pModel->pIB->Unlock();

	D3DXCreateTextureFromFile(_pD3DDevice, _pTextureName, &_pModel->pTexture);
}
