/// @file RObject.h
#ifndef ROBJECT_H
#define ROBJECT_H
#include "../graphic/CoreGraphic.h"
#include "../input/CoreInput.h"
#include "../sound/OggPlayer.h"

#include "../../xml/tinyxml.h"
#include "ControlTable.h"

/**
	@brief   Ӱü ߻Ŭ

	  Ӱü RObjectŬ ӹ޽ϴ.\n
	client process/draw Լ ȣϸ  process/draw  ü մϴ.
*/
class RObject {
	public:
		RObject() : bShow(FALSE), fX(0), fY(0), fZ(0) {}
		virtual ~RObject(){}
		virtual void draw(Model* _pModel) = 0;
		virtual void process() = 0;
		virtual void setRObject(CoreGraphic* _pCoreGraphic, CoreInput* _pCoreInput, OggPlayer* _pCoreSound, ControlTable* _pControlTable) = 0;
	public:
		bool  bShow;
		float fX;
		float fY;
		float fZ;

	protected:
		//  matڷ(RObject R Renderable̴)
		D3DXMATRIXA16 matWorld_;
		//  ControlTable
		ControlTable* pControlTable_;
};
#endif