module testM {
	provides {
		interface StdControl;
	}
	uses {
		interface Leds;
		interface Timer;
		interface SensorAPP as IFADC;
		interface SensorAPP as IFINTR;
		interface SensorAPP as IFI2C;
	}
}
implementation {
	uint8_t sht71_status = 0;
	command result_t StdControl.init(){
		call Leds.redOff();
		call Leds.yellowOff();
		call Leds.greenOff();
		call IFADC.open();
		call IFINTR.open();
		call IFI2C.open();
		return SUCCESS;
	}

	command result_t StdControl.start(){
		call IFI2C.ioctl(SENSOR, SET_TYPE, MEASURE_HUM);
		return call Timer.start(TIMER_REPEAT, 1000);
	}

	command result_t StdControl.stop() {
		return call Timer.stop();
	}
	
	event result_t Timer.fired() {
		call IFADC.read();
		call IFINTR.read();
		call IFI2C.read();
		atomic{
			sht71_status = call IFI2C.ioctl(SENSOR, GET_TYPE, 0);
		}
		return SUCCESS;
	}

	async event result_t IFADC.readReady(void *data){
		if(*((uint16_t*)data) & 0x0200)
			call Leds.redOn();
		else
			call Leds.redOff();
		
		return SUCCESS;
	}

	async event result_t IFINTR.readReady(void *data){
		return call Leds.greenToggle();
	}

	async event result_t IFI2C.readReady(void *data){
		if(sht71_status == MEASURE_TEMP)
		{
			if(*((float*)data) > 30)
				call Leds.yellowOn();
			else
				call Leds.yellowOff();
		}
		else if(sht71_status == MEASURE_HUM)
		{
			if(*((float*)data) > 70)
				call Leds.yellowOn();
			else
				call Leds.yellowOff();
		}
		return SUCCESS;
	}
	
}
