module testM {
	provides {
		interface StdControl;
	}
	uses {
		interface Leds;
		interface Timer;
		interface SensorAPP;
	}
}
implementation {
	uint8_t led_data = 0;
	command result_t StdControl.init(){
		call Leds.redOff();
		call Leds.yellowOff();
		call Leds.greenOff();
		call SensorAPP.open();
		return SUCCESS;
	}

	command result_t StdControl.start(){
		call SensorAPP.ioctl(SENSOR, SET_TYPE, MEASURE_HUM);
		return call Timer.start(TIMER_REPEAT, 1000);
	}

	command result_t StdControl.stop() {
		return call Timer.stop();
	}
	
	event result_t Timer.fired() {
		call Leds.redToggle();
		call SensorAPP.read();
		return SUCCESS;
	}
	
	async event result_t SensorAPP.readReady(void *data){
		if(*((float*)data) > 70)
			call Leds.yellowOn();
		else
			call Leds.yellowOff();
		
		return SUCCESS;
	}
}
