require"lfs"
require"iuplua"
require"install_component"
require"web_download"

local install_dir = ''
if arg[1] then 
	install_dir = string.gsub(arg[1], '\\', '/')
	install_dir = string.gsub(install_dir, '.%:', '')
end

install_dir = string.gsub(install_dir, '%"', '')
if string.sub(install_dir, -1) ~= '/' then
	install_dir = install_dir .. '/'
end

local components = {}
function component(t)
	table.insert(components, t)
end

local ok_button = iup.button{
	title = '',
}

local overall_progress = iup.progressbar{
	dashed="YES",
	min=0,
	expand="HORIZONTAL",
}

local comp_progress = iup.progressbar{
	dashed="YES",
	min=0,
	expand="HORIZONTAL",
}

local output_pane = iup.text{
	expand="YES",
	multiline="YES",
	readonly="YES",
	fgcolor="0 255 0",
	bgcolor="0 0 0",
	scrollbar="VERTICAL",
	wordwrap="YES",
	value=[[
* ں ѱ(http://docbook.kr/)   ġ α׷  پ ϵ  ޾Ƽ  ͸ ġմϴ. ġ  ׸ ġ   ࿡  Ȥ   ִ ؿ   α׷ ۼڵ ڵ  åӵ  ʽϴ. 

* ġ α׷鿡  ǰ ۱ ˴ϴ. ü ۱,   installer/files/  ϵ ȿ  ֽϴ.

*  ġ α׷ ü  ǿ ؼ installer/files.dbkpack-installer.txt .
	]]
}
local output_label = iup.label{
	expand="HORIZONTAL",
	padding="4x4"
}

local function output(str)
	output_pane.value = output_pane.value .. str
	iup.Flush()
end

local function outputln(str)
	output_pane.Append = str
end

local function exit_app()
  iup.ExitLoop()
  main_dlg:destroy()
end

local function run_configure(output_func)
	lfs.chdir('..')
	output_func(' :')
	local p = io.popen('configure.bat --nopause')
	for line in p:lines() do
		output_func(line)
	end
	p:close()
	output_func('Ϸ.')

end

local install_pending = false
local dialog_closing = false

local main_dlg = iup.dialog{
	title="ں  ġ",
	size="320x200",
	expand="YES", maxbox="NO", minbox="NO"
	;
	iup.vbox{
		iup.hbox{
			iup.label{
				title=" ͸ ں  ġմϴ.\n  ư Ŭϱ   Ʒ   о.  ",
				padding="4x4"
			},
			ok_button,
		},
		iup.frame{iup.vbox{
			output_pane,
			iup.label{
				title="ü  :  ",
				padding="4x4"
			},			
			overall_progress,
			output_label,
			comp_progress,
		}}
	};

	close_cb = function()
		if not install_pending 	then
			dialog_closing = true
			return iup.CLOSE
		end
		if (1 == iup.Alarm(
				"ġ ", "ġ Ϸ ʾҽϴ.  ұ?", 
				"", "")
			)
		then
			dialog_closing = true
			return iup.CLOSE
		end

		return iup.IGNORE
	end
}

ok_button.action=function()
	ok_button.active="NO"
	install_pending = true

	local bytes = 0
	local function report_download_progress(chunk)
		if dialog_closing then
			return nil
		end
		if chunk then
			bytes = bytes + string.len(chunk)
		end
		comp_progress.value = bytes
		iup.LoopStep()
		return true
	end

	local function report_extract_progress()
		if dialog_closing then
			return nil
		end
		comp_progress.value = comp_progress.value + 1
		if comp_progress.value > comp_progress.max then
			comp_progress.value = 0
		end
		iup.LoopStep()
		return true
	end

	local tempdir = 'files/'
	overall_progress.max = #components
	overall_progress.value = 0
	local err = nil
	for i, spec in ipairs(components) do
		spec.filename = spec.filename or get_filename(spec.url)
		local done_file = io.open(tempdir..spec.filename..'.done', 'r')
		if done_file then
			done_file:close()
		else -- need to install
			output_label.title = spec.name .. " ġ: "
			if not lfs.attributes(tempdir..spec.filename) then 
				spec.filesize = spec.filesize or get_remote_filesize(spec.url, 12345678)
				comp_progress.max = spec.filesize
				comp_progress.value = 0
				bytes = 0
				outputln(spec.filename .. '   ް ֽϴ:')
				err = download_file(spec.url, tempdir..spec.filename, 
					spec.filesize, report_download_progress)
				if err then 
					outputln("** : " .. err)
					break
				else
					outputln("Ϸ.")
				end
			end
			comp_progress.max = 100
			comp_progress.value = 0
			outputln(spec.filename .. "   Ǯ ֽϴ:")
			err = install_files(spec, report_extract_progress, install_dir)
			if err then
				outputln("** : " .. err)
				break
			end
			outputln("Ϸ.")
			io.open(tempdir..spec.filename..'.done', 'w'):close()
		end
		overall_progress.value = i
	end -- for

	install_pending = false

	if err then
		output_label.title = "ġ   ־ϴ."
	else
		output_label.title = "  ۾ մϴ."
		run_configure(outputln)
		output_label.title = "ġ ϴ. README.html о !"
		iup.Message("ġ Ϸ", [[ġ  ϴ.   ġ α׷ ݰ,  ͸   README.html о !]])
	end
	comp_progress.value = 0
	iup.Flush()
end

local function main()
	main_dlg:show()

	if (iup.MainLoopLevel()==0) then
	  iup.MainLoop()
	end
end

dofile"dbkspec.lua"
main()
