<%
class RoundBox
	private parent
	private inner_table
	private self_lineColor
	private self_lineWidth
	private self_borderWidth
	private self_borderHeight
	private self_leftTopImage
	private self_rightTopImage
	private self_leftBottomImage
	private self_rightBottomImage
	private self_base

	public property let lineColor(p_lineColor)
		self_lineColor = p_lineColor
	end property
	public property let lineWidth(p_lineWidth)
		self_lineWidth = p_lineWidth
	end property
	public property let borderWidth(p_borderWidth)
		self_borderWidth = p_borderWidth
	end property
	public property let borderHeight(p_borderHeight)
		self_borderHeight = p_borderHeight
	end property
	public property let leftTopImage(p_leftTopImage)
		self_leftTopImage = p_leftTopImage
	end property
	public property let rightTopImage(p_rightTopImage)
		self_rightTopImage = p_rightTopImage
	end property
	public property let leftBottomImage(p_leftBottomImage)
		self_leftBottomImage = p_leftBottomImage
	end property
	public property let rightBottomImage(p_rightBottomImage)
		self_rightBottomImage = p_rightBottomImage
	end property
	public property let base(p_base)
		self_base = p_base
	end property


	private sub Class_Initialize()
		set parent = new Table
		self_lineColor = "#d4d4d4"
		self_lineWidth = "1px"
		self_borderWidth = "2px"
		self_borderHeight = "3px"
		self_leftTopImage = "roundbox_lefttop.gif"
		self_rightTopImage = "roundbox_righttop.gif"
		self_leftBottomImage = "roundbox_leftbottom.gif"
		self_rightBottomImage = "roundbox_rightbottom.gif"
		self_base = "cshtmlwrapper/images"

		SetAttr "style", "border-collapse: collapse; border: 0;"
		set inner_table = new Layout
		inner_table.SetAttr "style", "border: 0;"
	end sub
	private sub Class_Terminate()
		set inner_table = Nothing
	end sub

	public sub Add(obj)
		inner_table.Add obj
	end sub

	public function toStr()
		dim lefttop, top, righttop
		dim left, right
		dim leftbottom, bottom, rightbottom
		dim lefttop_image, righttop_image, leftbottom_image, rightbottom_image

		lefttop_image = self_base & "/" & self_leftTopImage
		righttop_image = self_base & "/" & self_rightTopImage
		leftbottom_image = self_base & "/" & self_leftBottomImage
		rightbottom_image = self_base & "/" & self_rightBottomImage

		lefttop = array(" ", "style=""width: " & self_borderWidth & "; height: " & self_borderHeight & "; background-image: url('" & lefttop_image & "');""")
		top = array("", "style='width: " & self_borderWidth & "; height: " & self_borderHeight & "; border: solid " & self_lineColor & " 0px; border-top-width: " & self_lineWidth & ";'")
		righttop = array(" ", "style=""width: " & self_borderWidth & "; height: " & self_borderHeight & "; background-image: url('" & righttop_image & "'); border: 0;""")

		left = array("", "style='width: " & self_borderWidth & "; border: solid " & self_lineColor & " 0px; border-left-width: " & self_lineWidth & ";'")
		right = array("", "style='width: " & self_borderWidth & "; border: solid " & self_lineColor & " 0px; border-right-width: " & self_lineWidth & ";'")

		leftbottom = array(" ", "style=""width: " & self_borderWidth & "; height: " & self_borderHeight & "; background-image: url('" & leftbottom_image & "');""")
		bottom = array("", "style='width: " & self_borderWidth & "; height: " & self_borderHeight & "; border: solid " & self_lineColor & " 0px; border-bottom-width: " & self_lineWidth & ";'")
		rightbottom = array(" ", "style=""width: " & self_borderWidth & "; height: " & self_borderHeight & "; background-image: url('" & rightbottom_image & "');""")

		parent.Add array(lefttop, top, righttop)
		parent.Add array(left, inner_table, right)
		parent.Add array(leftbottom, bottom, rightbottom)
		toStr = parent.toStr()
	end function

	public sub Print()
		Response.Write toStr()
	end sub
%>
<!--#include file="Object.inc.asp"-->
<%
end class
%>
