<%
'
' CS HTML Wrapper
' Copyright (C) 2008, D&SOFT
' diver@coolsms.co.kr
'
class PageBar
	private parent
	private currentPage
	private totalCount
	private rowsPerPage

	private totalPages
	private pagesPerThread
	private currentThread
	private totalThreads

	private self_addparams

	private sub Class_Initialize()
		set parent = new Layout
		currentPage = 0
		totalCount = 0
		rowsPerPage = 10
		pagesPerThread = 10
		'totalPages = Round((totalCount / rowsPerPage) + 0.5)
		'currentThread = int(((currentPage-1) / pagesPerThread) + 0.5)
		'totalThreads = Round((totalPages / pagesPerThread) + 0.5)
		self_addparams = ""
	end sub

	public property let pCurrentPage(currentPage_)
		currentPage = currentPage_
	end property
	public property let pTotalCount(totalCount_)
		totalCount = totalCount_ 
	end property
	public property let pRowsPerPage(rowsPerPage_)
		rowsPerPage = rowsPerPage_ 
	end property
	public property let pAddParams(addparams_)
		self_addparams = addparams_
	end property

	public sub AddParams(addparams_)
		if self_addparams = "" then
			self_addparams = addparams_
		else
			self_addparams = self_addparams & "&" & addparams_
		end if
	end sub

	public function toStr()
		totalPages = Round((totalCount / rowsPerPage) + 0.49)
		currentThread = int((currentPage-1) / pagesPerThread)
		totalThreads = Round((totalPages / pagesPerThread) + 0.49)

		LeftDir()
		Pages()
		RightDir()

		toStr = parent.toStr()
	end function

	private function LeftDir()
		dim page
		dim a

		if currentThread <= 0 then
			exit function
		end if

		page = ((currentThread-1) * pagesPerThread) + 1
		if page <= 1 then
			page = 1
		end if

		set a = new Anchor
		if self_addparams = "" then
			a.url = "?page=" & page
		else
			a.url = "?page=" & page & "&" & self_addparams
		end if
		a.Add "  "

		parent.Add a
	end function

	private function RightDir()
		dim page
		dim a

		if currentThread >= (totalThreads-1) then
			exit function
		end if

		page = ((currentThread+1) * pagesPerThread) + 1
		if page > totalPages then
			page = totalPages
		end if

		set a = new Anchor
		if self_addparams = "" then
			a.url = "?page=" & page
		else
			a.url = "?page=" & page & "&" & self_addparams
		end if
		a.Add "  "

		parent.Add a
	end function

	function Pages()
		dim start
		dim end_
		dim a
		dim i

		start = (currentThread * pagesPerThread) + 1
		end_ = (currentThread + 1) * pagesPerThread
		if end_ >= totalPages then
			end_ = totalPages
		end if

		for i = start to end_ step 1
			set a = new Anchor
			if self_addparams = "" then
				a.url = "?page=" & i & "&" & self_addparams
			else
				a.url = "?page=" & i & "&" & self_addparams
			end if
			a.Add i & " "
			if i = currentPage then
				a.SetAttr "style", "color: red"
			end if
			parent.Add a
		next
	end function

	public sub Print()
		Response.Write toStr()
	end sub
%>
<!--#include file="Layout.inc.asp"-->
<%
end class
%>
